#!/bin/sh
#Accumule les impressions
SPOOLDIR=/home/data/preview
TMPNAME=$(uuidgen)

sleep 2
cat - >$SPOOLDIR/$TMPNAME
ftype=$(file -b $SPOOLDIR/$TMPNAME |tr A-Z a-z)
fname=$SPOOLDIR/$TMPNAME
case $ftype in
	*postscript* )
		fname=$fname.ps
	;;
	*hp* )
		fname=$fname.plt
	;;
	*ascii* )
		fname=$fname.ascii
	;;
	* )
		fname=$fname.job
	;;
esac
mv $SPOOLDIR/$TMPNAME $fname
(# Write accross text file
	echo "%% Header file for $fname"
	echo "PrintFile: $fname"
	echo "ReqDate: $(date)"
	echo "User: $USER"
	echo "Printer: ${PWD##*/}"
	echo "======================================="
	set
) >$SPOOLDIR/$TMPNAME.txt

