#!/bin/sh
#Transforme les impressions en fichier pdf, puis mail retour.

export ToAdd="$USER@localhost"
export ToSub="Mail retour: Fichier PDF demand"
export cttyp="Application/OCTET-STREAM"
export cdesc="Fichier PDF automatique"
export TMPNAME=/tmp/pdfprint-$(date "+%d-%m-%Y_%H-%M-%S")-$$
[ -f /etc/sysconfig/i18n ] && . /etc/sysconfig/i18n

sleep 2
cat - >$TMPNAME

ftype=$(file -b $TMPNAME |tr A-Z a-z)

>$TMPNAME.txt
addtxt() {
    echo -e "$1" >>$TMPNAME.txt
}
addtxt "Le $(date "+%e %B %Y  %Hh%M\047%S"), $USER  envoy le fichier:"

case $ftype in
	*postscript* )
		fname=$TMPNAME.ps
		mv $SPOOLDIR/$TMPNAME $fname
		if ps2pdf $TMPNAME.ps $TMPNAME.pdf ;then
		    addtxt "\n$TMPNAME.pdf\n"
		    addtxt "que j'ai transform et qui est un fichier pdf"
		    cnt=1
		    gs -sDEVICE=bbox -r30 -dBATCH -dNOPAUSE $TMPNAME.ps 2>&1|\
		    grep "^%%H" |\
		    while read a b c d e;do
			echo "size=30;\
				scale=12;\
				fac=2.54/72;\
				lar=($d-$b)*fac;\
				hau=($e-$c)*fac;\
				print lar,\" \",hau,\" \";lar*hau" \
			| bc -l
		    done \
		    | #tr "." "," |\
		    while read a b c;do
			printf "%.2fcm %.2fcm %3.3fcm\n" $a $b $c
		    done |\
		    while read a b c;do
			addtxt "$(printf "Page n%3d: %9s x %9s := %9s\n" \
			    $cnt $a $b $c)"
			cnt=$(($cnt+1))
		    done
		    fname=$TMPNAME.pdf
		    export cttyp="Application/PDF"
		else
		    addtxt "\n$TMPNAME.ps\n"
		    export cttyp="Application/Postscript"
		    addtxt "qui n'a pas pu tre transform en PDF"
		    export cdesc="Fichier envoy, non transform"
		fi
		;;
	* )
		fname=$TMPNAME
		addtxt "\n$fname\n"
		addtxt "qui n'est pas un fichier PostScript, mail plutt"
		addtxt "un fichier '$ftype'\n"
	;;
esac
addtxt "--\nAvec les salutation respectueuses de votre robot dvou.\n"

(
    bnd="----=_PartieSuivante_$(uuidgen)"
    echo -e "From: Automail <$USER@$HOSTNAME>\nSubject: $ToSub \n\
MIME-Version: 1.0\n\
Content-Type: multipart/mixed; boundary=\"$bnd\"\n\n--$bnd\n\
Content-Type: text/plain; charset=ISO-8859-1\n\
Content-Transfer-Encoding: 8bit\n\
Content-Description: Texte du courier\nContent-Disposition: attachment;\n\
    filename=\"${fname%.*}.txt\"\n"
    cat $TMPNAME.txt
    echo -e "\n--------------------------------------------------------------\
------------------\nLe service automatique PDFMail de Flix Hauri \
<hauri_felix@bluewin.ch>\n\n--$bnd\nContent-Type: $cttyp; name \"$fname\"\n\
Content-Transfer-Encoding: base64\n\
Content-Description: $cdesc\n\
Content-Disposition: attachment;\n\
    filename=\"$fname\"\n"
    cat $fname | mimencode
    ) | /usr/sbin/sendmail $ToAdd
rm -f $TMPNAME.* $TMPNAME
